#' Draws an aspect elevation rose diagram inside an existing plot.
#'
#' Draws an aspect elevation rose diagram inside an existing plot.
#' @param x x coordinate of centre point
#' @param y y coordinate of centre point
#' @param rx Radius in x dimension
#' @param ry Radius in y dimension. Default is x_radius
#' @param col Array with 3 colors to be plotted in circles (alp, tl, btl)
#'
#' @export

drawAspElevRoseDiagramInsidePlot <- function(x, y, rx, ry=rx, col, lwd=0.5) {

  if (!isPackageInstalled("shape")) {stop("This function requires package 'shape' to be installed!")}

  if (length(col)==3) {

    shape::plotellipse(mid=c(x,y), rx=rx, ry=ry, col=col[3], lwd=lwd)
    shape::plotellipse(mid=c(x,y), rx=0.66*rx, ry=0.66*ry, col=col[2], lwd=lwd)
    shape::plotellipse(mid=c(x,y), rx=0.33*rx, ry=0.33*ry, col=col[1], lwd=lwd)

  } else {

    stop("Currently only supports three elevation band without any aspect sectors! The parameter col therefore needs to include three colors in hex format.")

  }

}
