#' Gets standard color for avalanche character.
#'
#' Gets standard color for avalanche character.
#' @param AvCharLabel Value of avalanche character.
#' @param Transparency String value of transparency. Value must be between '00' (fully transparent) and '99' (almost fully opaque). Default value is NA (fully opaque).
#' @return Color in HTML hex code
#'
#' @export

getAvCharColor <- function(AvCharLabel, Transparency=NA) {

  ## Function definition for single value
  getAvCharColorSingle <- function(AvCharLabel, Transparency=NA) {

    AvCharLabel <- toupper(AvCharLabel)

    if(is.na(AvCharLabel)) {
      AvCharCol <- "#DDD8D6"
      warning(paste0("No avalanche character value provided!"), immediate.=T)
    } else if (AvCharLabel=="STORM_SLAB"           | AvCharLabel=="STORM SLABS") {
      AvCharCol <- "#FDD017"
    } else if (AvCharLabel=="PERSISTENT_SLAB"      | AvCharLabel=="PERSISTENT SLABS") {
      AvCharCol <- "#F62217"
    } else if (AvCharLabel=="DEEP_PERSISTENT_SLAB" | AvCharLabel=="DEEP PERSISTENT SLABS") {
      AvCharCol <- "#9F000F"
    } else if (AvCharLabel=="WIND_SLAB"            | AvCharLabel=="WIND SLABS") {
      AvCharCol <- "#4CC417"
    } else if (AvCharLabel=="CORNICE"              | AvCharLabel=="CORNICES") {
      AvCharCol <- "#347235"
    } else if (AvCharLabel=="WET_SLAB"             | AvCharLabel=="WET SLABS") {
      AvCharCol <- "#2B65EC"
    } else if (AvCharLabel=="LOOSE_WET_AVALANCHE"  | AvCharLabel=="LOOSE WET") {
      AvCharCol <- "#79BAEC"
    } else if (AvCharLabel=="LOOSE_DRY_AVALANCHE"  | AvCharLabel=="LOOSE DRY") {
      AvCharCol <- "#C8A2C8"
    } else if (AvCharLabel=="GLIDE"  | AvCharLabel=="GLIDE") {
      AvCharCol <- "#808080"
    } else if (AvCharLabel=="MULTIPLE") {
      AvCharCol <- "#000000"
    } else {
      AvCharCol <- "#DDD8D6"
      warning(paste0("Avalanche character '", AvCharLabel, " not supported! Check spelling!"), immediate.=T)
    }

    if (!is.na(Transparency)) {
      AvCharCol <- paste0(AvCharCol, Transparency)
    }

    return (AvCharCol)
  }

  ## Application of function to array
  AvCharCol <- sapply(AvCharLabel, getAvCharColorSingle, Transparency=Transparency)

  return(AvCharCol)

}
