#' Gets standard color for hazard rating.
#'
#' Gets standard color for hazard rating.
#' @param HzdValue Single value or array of values of hazard ratings.
#' @param Transparency String value of transparency. Value must be between '00' (fully transparent) and '99' (almost fully opaque). Default value is NA (fully opaque).
#' @param DefaultCol Default color for na value in hex format. Default value is '#DDD8D6' (grey).
#' @return Color in HTML hex code
#'
#' @export

getHzdColor <- function(HzdValue, Transparency=NA, DefaultCol="#DDD8D6") {

  HzdValue <- toupper(HzdValue)

  if(length(HzdValue)==1 & is.na(HzdValue[1])) {
    HzdCol <- DefaultCol
  } else {
    HzdCol <- rep(DefaultCol, length(HzdValue))
    for (Index in 1:length(HzdValue)) {
      if(is.na(HzdValue[Index])) {
        HzdCol[Index] <- DefaultCol
      } else if (HzdValue[Index]=="1"      | HzdValue[Index]=="1 - LOW"          | HzdValue[Index]=="LOW") {
        HzdCol[Index] <- ClrDRLow
      } else if (HzdValue[Index]=="2"      | HzdValue[Index]=="2 - MODERATE"     | HzdValue[Index]=="MODERATE") {
        HzdCol[Index] <- ClrDRMod
      } else if (HzdValue[Index]=="3"      | HzdValue[Index]=="3 - CONSIDERABLE" | HzdValue[Index]=="CONSIDERABLE") {
        HzdCol[Index] <- ClrDRCon
      } else if (HzdValue[Index]=="4"      | HzdValue[Index]=="4 - HIGH"         | HzdValue[Index]=="HIGH") {
        HzdCol[Index] <- ClrDRHig
      } else if (HzdValue[Index]=="5"      | HzdValue[Index]=="5 - EXTREME"      | HzdValue[Index]=="EXTREME") {
        HzdCol[Index] <- ClrDRExt
      } else if (HzdValue[Index]=="SPRING" | HzdValue[Index]=="'SPRING'") {
        HzdCol[Index] <- ClrDRSpr
      } else if (HzdValue[Index]=="N/A"    | HzdValue[Index]=="NA"               | HzdValue[Index]==""
                                           | HzdValue[Index]=="NO RATING"        | HzdValue[Index]=="No Rating") {
        HzdCol[Index] <- DefaultCol
      } else {
        stop(paste0("Hazard ", HzdValue, " not supported! Check spelling!"))
        HzdCol[Index] <- DefaultCol
      }
    }
  }

  if(!is.na(Transparency)){
    HzdCol <- paste0(HzdCol, Transparency)
  }

  return (HzdCol)

}
