#' Checks whether points are in one of multiple polygons in a SPDF
#'
#' Checks whether points are in one of multiple polygons in a SPDF.
#' @param PointX X coordinate of point of points.
#' @param PointY Y coordinate of point of points.
#' @param SPDF_Polygon Spatial dataframe of type polygon.
#' @param ValueInside. Result value for points that are inside the polygon.
#' @param ValueOutside. Result value for points that are outside the polygon.
#' @return Array with inside and outside values
#'
#' @export

isPointInSPDFPolygons <- function(PointX, PointY, SPDF_Polygon, ValueInside=1, ValueOutside=0) {

  ## Initialize
  MarkerArray <- rep(ValueOutside, length(PointX))

  ## Loop for polygon entries
  for (Index_1 in 1:length(SPDF_Polygon@polygons)) {

    ## Loop for multipolygons
    for (Index_2 in 1:length(SPDF_Polygon@polygons[[Index_1]]@Polygons)) {

      ## Calculation
      MarkerArray <- ifelse(point.in.polygon(PointX,
                                             PointY,
                                             SPDF_Polygon@polygons[[Index_1]]@Polygons[[Index_2]]@coords[,1],
                                             SPDF_Polygon@polygons[[Index_1]]@Polygons[[Index_2]]@coords[,2])==1, 1, MarkerArray)

    }

  }

  return(MarkerArray)
}
