#' Rearranges columns of a data.frame
#'
#' Rearranges columns of a data.frame.
#' @param DF data.frame to be rearranged.
#' @param refCols Array with column names to be the first columns (default=names(DF)).
#' @return Rearranged data.frame.
#' @export

rearrangeDFColumnsByName <- function(DF, refCols=names(DF)){

  DF <- DF[, c(refCols, setdiff(names(DF), refCols))]
  return(DF)

}
