#' Splits a dataframe consistent into a test and traning dataset.
#'
#' Splits a dataframe consistent into a test and traning dataset.
#' @param df Input dataframe
#' @param seed Random seed for sampling. Default is 1234 to create consistent samples. Replace with random number to create different samples.
#' @param p Size of training dataset in a proportion (i.e., value between 0 and 1)
#' @return List with three elements: origin (original data frame), train (training data frame), and test (test data frame)
#'
#' @examples
#' require(SarpGeneral)
#'
#' Data <- data.frame(x=c(1:100), y=c(100:1))
#'
#' Samples <- splitDFTrainTest(Data)
#' Samples <- splitDFTrainTest(Data, p=0.9)
#'
#' @export

splitDFTrainTest <- function(df, seed=1234, p = 0.75){

  ## Rows included in training set
  n_train <- round(p * nrow(df))
  set.seed(seed)
  train_indicies <- sample(1:nrow(df), n_train)

  ## subset for training and testing
  df_train <- df[train_indicies, ]
  df_test <- df[-train_indicies, ]

  return(list(origin=df,
              train=df_train,
              test=df_test))
}
