#' Function that repeats calls to Database
#'
#' Function that repeats calls to Database, a potential solution for random connectivity issues.
#' @param DBFunction A function that calls database.
#' @param MaxNumTries Number of maximum tries that are attempted. Default value is 10.
#' @param Pause Length of pause in seconds. Default value is 2 sec.
#' @return DBObject Object called from Database.
#'
#' @examples
#'	require(SarpBulletinTools)
#'	require(SarpBulletinToolsPrivate)
#'
#'	reg <- c("South Coast","North Columbia","South Columbia","Kootenay Boundary","South Rockies","Northwest - BC","North Rockies - BC")
#'	avPr <- c('Storm Slabs','Wind Slabs', 'Persistent Slabs', 'Deep Persistent Slabs','Wet Slabs','Loose Wet','Loose Dry','Cornices' )
#'
#'	# Loop for Region list
#'	for(r in 1:length(reg)) {
#'		# Loop for Avalanche Problems
#'		for(a in 1:length(avPr)) {
#'			Bulletins <- tryMultipleTimes(getBulletins(Agency = 'AvCan',
#'		                              Seasons = 2010,
#'		                              Regions = reg[r]))
#'		}
#'	}
#'
#' @export

tryMultipleTimes <- function(DBFunction, MaxNumTries=10, Pause=2) {

  ## Initialize parameter
  Success <- FALSE
	Tries <- 0

	## Repeat loop
	repeat{

		## Exit condition
		if(Success == TRUE) break
	  if(Tries > MaxNumTries) {
	    warning(paste0("Unsuccessful, but maximum number of tries reached (", MaxNumTries, ")"), immediate.=T)
	    DBObj <- NA
	    break
	  }

		## Database call
	  Tries <- Tries + 1
	  DBObj <- try(DBFunction)

	  ## Checking result of database call
		if(class(DBObj)[1] == 'try-error' ) {
			Sys.sleep(Pause)
			print(paste0('Trying again ... (', Tries, ' of ', MaxNumTries, ')'))
		} else {
			Success <- TRUE
		}
	}

	## Return result
	return(DBObj)

}
