% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callDB.R
\name{callDB}
\alias{callDB}
\title{Function that repeats calls to Database}
\usage{
callDB(DBFunction, MaxNumTries = 10)
}
\arguments{
\item{DBFunction}{A function that calls database.}

\item{MaxNumTries}{Number of maximum tries that are attempted. Default value is 10.}
}
\value{
DBObject Object called from Database.
}
\description{
Function that repeats calls to Database, a potential solution for random connectivity issues.
}
\examples{
require(SarpBulletinTools)
require(SarpBulletinToolsPrivate)
require(SarpGeneral)
reg <- c("South Coast","North Columbia","South Columbia","Kootenay Boundary","South Rockies","Northwest - BC","North Rockies - BC")
avPr <- c('Storm Slabs','Wind Slabs', 'Persistent Slabs', 'Deep Persistent Slabs','Wet Slabs','Loose Wet','Loose Dry','Cornices' )
# Loop for Region list
for(r in 1:length(reg))
{
	# Loop for Avalanche Problems
	for(a in 1:length(avPr))
	{
		Bulletins <- callDB(getBulletins(Agency = 'AvCan',
	                              Seasons = 2010,
	                              Regions = reg[r]))
		AlpAvProb <- Bulletins$AvProblems[['Alp']]
		plotHzdChartCount(AlpAvProb[AlpAvProb$CHARACTER==avPr[a],],
		                  Shape = "Square",
		                  Percent = TRUE,
		                  PercentInterval=10,
		                  Title=paste0('2010 ', reg[r], ': Alp ',avPr[a]),
		                  cex.AdditionalText=0.75)
	}
}

}
