% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colorFromColorRamp.R
\name{colorFromColorRamp}
\alias{colorFromColorRamp}
\title{Convert value array into colors from a color ramp}
\usage{
colorFromColorRamp(ValueArray, Col1 = "blue", Col2 = "red",
  BreakNum = 10, BreakValues = NA)
}
\arguments{
\item{ValueArray}{Array of numeric values for color array}

\item{Col1}{Color for lowest value. Default value is 'blue'.}

\item{Col2}{Color for highest value. Default value is 'red'.}

\item{BreakNum}{Number of breaks for splitting value array.}

\item{BreakValues}{Array with values for breaking array apart in asending order. Must include min and max values. Values that are outside of the range are ignored.}
}
\value{
Array of color values in hex format.
}
\description{
Convert value array into colors from a color ramp.
}
\examples{
require(SarpGPSTools)
require(SarpGPSToolsPrivate)

Oper <- "CMHGL"
User <- "SARPLab"

## Get list of ski run uuids
UUIDs <- getRecordsFromQuery(Oper, "Select loccatskiruns_uuid FROM gis.loccatskiruns_array_coord")$loccatskiruns_uuid

## Select one run and extract coordinates and incline values
RunUUID <- UUIDs[15]
CoordDF <- data.frame(lat  = convertArrayFromSQL(getRecordsFromUUID(Oper, "gis", "loccatskiruns_array_coord", UUID=RunUUID, UUIDCol="loccatskiruns_uuid", ResultCol="lat", Verbose=F, SuppressPostgreSQLWarnings=T, SuppressOrderWarning=T)$lat),
                      lon  = convertArrayFromSQL(getRecordsFromUUID(Oper, "gis", "loccatskiruns_array_coord", UUID=RunUUID, UUIDCol="loccatskiruns_uuid", ResultCol="lon", Verbose=F, SuppressPostgreSQLWarnings=T, SuppressOrderWarning=T)$lon),
                      val = convertArrayFromSQL(getRecordsFromUUID(Oper, "gis", "loccatskiruns_array_incline",  UUID=RunUUID, UUIDCol="loccatskiruns_uuid", ResultCol="valuearray", Verbose=F, SuppressPostgreSQLWarnings=T, SuppressOrderWarning=T)$valuearray))

## Get outline of ski run polygon
Skirun <- getSpatialObjectsFromUUID(Oper, "loccat", "skiruns", UUID = RunUUID)

## Add color to incline values
CoordDF$Col <- colorFromColorRamp(CoordDF$val, Col1="yellow", Col2="red", BreakValues = c(15, 25, 35, 45, 55))

## Plotting values and skirun outline
plot(CoordDF$lon, CoordDF$lat, pch=20, col=CoordDF$Col, cex=0.75, main="Slope Incline", ylab="lon", xlab="lat")
plot(Skirun, border="black", add=T)

}
