% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deriveAvSeasonInfo.R
\name{deriveAvSeasonInfo}
\alias{deriveAvSeasonInfo}
\title{Derives avalanche season (typical operating season) info from winter year number.}
\usage{
deriveAvSeasonInfo(Season, Type = "AvYear", StartDate = NA,
  EndDate = NA, OutputFormat = NA)
}
\arguments{
\item{Season}{Single or array of winter season numbers.}

\item{Type}{Specifies whether a season is a full year ('AvYear'; default) or just the main winter months ('Operation') or a custom date range ('Custom'), which can be specified with the StartDate and EndDate parameters.}

\item{StartDate}{Start date for custom season length. Format needs to be MM-DD.}

\item{EndDate}{End date for custom season length. Format needs to be MM-DD.}
}
\value{
List with single values or arrays of start and end dates for avalanche season
}
\description{
Derives avalanche season (typical operating season) info (start date, end date) from winter year number.
}
\examples{
Season <- c(2014, 2015)
SeasonInfo <- deriveAvSeasonInfo(Season)
StartDate <- SeasonInfo$StartDate
EndDate   <- SeasonInfo$EndDate

}
