% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitDFTrainTest.R
\name{splitDFTrainTest}
\alias{splitDFTrainTest}
\title{Splits a dataframe consistent into a test and traning dataset.}
\usage{
splitDFTrainTest(df, seed = 1234, p = 0.75)
}
\arguments{
\item{df}{Input dataframe}

\item{seed}{Random seed for sampling. Default is 1234 to create consistent samples. Replace with random number to create different samples.}

\item{p}{Size of training dataset in a proportion (i.e., value between 0 and 1)}
}
\value{
List with three elements: origin (original data frame), train (training data frame), and test (test data frame)
}
\description{
Splits a dataframe consistent into a test and traning dataset.
}
\examples{
require(SarpGeneral)

Data <- data.frame(x=c(1:100), y=c(100:1))

Samples <- splitDFTrainTest(Data)
Samples <- splitDFTrainTest(Data, p=0.9)

}
