% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tryMultipleTimes.R
\name{tryMultipleTimes}
\alias{tryMultipleTimes}
\title{Function that repeats calls to Database}
\usage{
tryMultipleTimes(DBFunction, MaxNumTries = 10, Pause = 2)
}
\arguments{
\item{DBFunction}{A function that calls database.}

\item{MaxNumTries}{Number of maximum tries that are attempted. Default value is 10.}

\item{Pause}{Length of pause in seconds. Default value is 2 sec.}
}
\value{
DBObject Object called from Database.
}
\description{
Function that repeats calls to Database, a potential solution for random connectivity issues.
}
\examples{
require(SarpBulletinTools)
require(SarpBulletinToolsPrivate)

reg <- c("South Coast","North Columbia","South Columbia","Kootenay Boundary","South Rockies","Northwest - BC","North Rockies - BC")
avPr <- c('Storm Slabs','Wind Slabs', 'Persistent Slabs', 'Deep Persistent Slabs','Wet Slabs','Loose Wet','Loose Dry','Cornices' )

# Loop for Region list
for(r in 1:length(reg)) {
	# Loop for Avalanche Problems
	for(a in 1:length(avPr)) {
		Bulletins <- tryMultipleTimes(getBulletins(Agency = 'AvCan',
	                              Seasons = 2010,
	                              Regions = reg[r]))
	}
}

}
