#' Merge snowprofile data with dem
#'
#' @param data dataframe with vstation value
#' @param dem dem with locations of vstations
#'
#' @return spatialpoints dataframe
#' @export
#'

addSpatial <- function(data, dem) {

  spdata <- merge(data, dem, by = 'vstation')
  sp::coordinates(spdata) <- ~ lon + lat
  sp::proj4string(spdata) <- sp::CRS('+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs')
  return(spdata)
  
}
