#' Aggregate layers by depostion date
#'
#' Aggregate layers with the same deposition date
#' @param profile snowprofile
#'
#' @return Snowprofile
#' 
#' @export

aggregateByDeposition <- function(profile) {
  
  # Creat a priority order for grain types (so we can calculate the max of an ordered factor)
  profile$grain_type <- factor(profile$grain_type, c('PP', 'DF', 'RG', 'PPgp', 'FCxr', 'MF', 'IF', 'MFcr', 'FC', 'DH', 'SH'), ordered = T)
  
  # Determine which rule to use for each parameter ~ mean, max or min
  properties.mean <- aggregate(profile[c('height', 'density', 'temperature', 'lwc')], by = list(profile$deposition_date), mean)
  properties.max  <- aggregate(profile[c('grain_size', 'grain_type')], by = list(profile$deposition_date), max)
  properties.min  <- aggregate(profile[c('hardness', 'ssi')], by = list(profile$deposition_date), min)
  
  # Regroup all the data and return
  out.profile <- merge(merge(properties.max, properties.min), properties.mean)
  names(out.profile)[1] <- 'deposition_date'
  
  ## Output
  return(out.profile)
}
