#' Format layer properties
#'
#' Formats datatime, grain types, and rounds values
#' @param layers dataframe of layer properties
#'
#' @return dataframe with formated layer properties

formatLayers <- function(layers) {
  
  layers$deposition_date <- as.Date(layers$deposition_date)
  layers$grain_class <- as.character(layers$grain_class)
  layers$grain_type <- sapply(layers$grain_class, function(x) ifelse(substr(x,3,3) == '2', 'MFcr', swisscode[as.integer(substr(x,1,1))]) )
  layers$grain_class <- NULL
  layers$grain_size <- round(layers$grain_size, 1)
  layers$temperature <- round(layers$temperature, 1)
  layers$height <- round(layers$height, 2)
  if ("ssi" %in% names(layers)) {
    layers$ssi[layers$ssi == -999] <- NA
    layers$ssi <- round(layers$ssi, 1)
  }
  return(layers)
  
}