#' Format weather
#'
#' Common cleaning and formatting for weather data
#' @param wx Dataframe of weather data
#' @param tz Time zone. Default is PST (Canada/Pacific).
#'
#' @return dataframe of weather data

formatWeather <- function(wx, tz = "Canada/Pacific") {
  
  wx$datetimeUTC <-  as.POSIXct(wx$datetimeUTC, tz = 'UTC')
  wx$datetime <-  as.POSIXct(wx$datetime, tz = tz)
  wx$date <- as.Date(wx$date)
  wx$ssi[wx$ssi == 999] <- NA
  return(wx)
  
}
