#' Get DEM from database
#' 
#' Query database to get DEM for studyArea and add spatial information
#' @param DBName database name
#'
#' @return spatial points dataframe
#' @export
#'
getDEM <- function(DBName, AlpTlElev = 1900, TlBtlElev = 1700) {
  
  ## Retrieve DEM from database
  query <- "SELECT * FROM `studyArea`"  
  dem <- SarpSnowGeneral::getRecordsFromQuery(DBName, query)
  
  ## Create spatial points dataframe
  sp::coordinates(dem) <- ~ lon + lat
  sp::proj4string(dem) <- sp::CRS('+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs')
  
  ## All elevation band column
  dem$band <- 'TL'
  dem$band[dem$elev < TlBtlElev] <- 'BTL'
  dem$band[dem$elev > AlpTlElev] <- 'ALP'
  
  ## Return
  return(dem)
}