#' Get newest timestamp
#'
#' @param DBName database name
#'
#' @return a POSIXct formated timestamp
#' @export
#'
getNewestTimestamp  <- function(DBName) {
  
  ## Get data from database
  query <- "SELECT max(`date`) FROM `profiles`"  
  timestamps <- SarpSnowGeneral::getRecordsFromQuery(DBName, query)
  
  ## Format
  timestamps <- as.POSIXct(as.vector(timestamps[,1]), tz = 'UTC')
  
  ## Return 
  return(timestamps)
  
}