#' List slopes in database
#'
#' @param DBName database name
#' @param dem merge with DEM (to output a spatialpoints dataframe)
#'
#' @return dataframe or spatialpoints dataframe
#' @export

listSlopes <- function(DBName, dem = NULL) {
  
  ## Get data from database
  query <- "SELECT DISTINCT `vstation_id`, `vstation`, `angle`, `aspect` FROM `timeseries`"  
  vstation_id <- SarpSnowGeneral::getRecordsFromQuery(DBName, query)
  
  ## Add spatial information when dem is provided as well
  if (is.null(dem)) {
    vstation_id <- vstation_id[,1]
  } else {
    vstation_id <- addSpatial(vstation_id, dem)
  } 
  
  ## Return
  return(vstation_id)
  
}
