#' List stations in database
#'
#' @param DBName database name
#' @param dem merge with DEM (to output a spatialpoints dataframe)
#'
#' @return dataframe or spatialpoints dataframe
#' @export

listStations <- function(DBName, dem = NULL) {
  
  ## get data from database
  query <- "SELECT DISTINCT `vstation` FROM `timeseries`"  
  vstations <- SarpSnowGeneral::getRecordsFromQuery(DBName, query)
  
  ## Add spatial information is dem is provided
  if (is.null(dem)) {
    vstations <- vstations[,1]
    #vstations <- as.numeric(timestamps[,1])
  } else {
    vstations <- addSpatial(vstations, dem)
  } 
  
  ## Return
  return(vstations)
  
}