#' List timestamps 
#'
#' List unique timestamps
#' @param DBName database name
#'
#' @return vector of POSIXct timestamps
#' @export
#'
listTimestamps <- function(DBName) {
  
  ## Get data
  query <- "SELECT DISTINCT `date` FROM `timeseries`"  
  timestamps <- SarpSnowGeneral::getRecordsFromQuery(DBName, query)
  
  ## Format
  timestamps <- as.POSIXct(as.vector(timestamps[,1]), tz = 'UTC')
  
  ## Return
  return(timestamps)
  
}