#' Plot hardness profile
#'
#' @param x snowprofile object
#' @param ... other parameters to barplot
#'
#' @export
#'
#' @examples
#' plot(snowprofile)
plot.snowprofile <- function(x, ...)
{
  layers <- x$layers
  par(las = T)
  # Draw horizontal barplot with hardness profile
  barplot(layers$hardness, width = c(layers$height[1], diff(layers$height)), 
          col = sapply(layers$grain_type, grainColLookup), 
          horiz = T, border = NA, space = 0, 
          xlim = c(0,5), xaxt = 'n', xlab = '', 
          ...)
  # Draw scaled temperature profile
  if ('temperature' %in% names(layers))
  {
    lines(layers$temperature/(max(layers$temperature) - min(layers$temperature) + 0.1)*2 + 2,
          layers$height, col = 'red')
  }
  # Add harndess and height axis
  axis(1, at = 1:5, labels = c('F', '4F', '1F', 'P', 'K'))
  axis(2)
}
