#' Plot a vertical parameter
#'
#' plot a vertical line
#' TODO: implement plotrix::rescale to colour code other parameters
#'
#' @param profile snowprofile object
#' @param x vector of x axis values to draw veritcal segments
#'
#' @export
#'
#' @examples
#' # Load data
#' profileLocation <- "HRDPS_518_700"
#' spros <- getProfiles(DBName, slopes = profileLocation, dem = dem)
#' 
#' # Define x-axis values
#' theDates <- as.Date(sapply(spros, function(x) x$date))
#' 
#' # Initialize empty plot
#' plot(NA, NA, ylim = c(0,250), xlim = c(min(theDates),max(theDates)), ylab = '', xlab = '')
#' 
#' # Draw segments
#' invisible(sapply(1:length(spros), function(i) plotParameter(spros[[i]], theDates[i])))
#'  
plotParameter <- function(profile, x)
{
  height <- profile$layers$height
  colours <- sapply(profile$layers$grain_type, grainColLookup)
  segments(x, 0, x, height[1], col = colours[1], lwd = 4)
  invisible(sapply(2:length(height), 
                   function(i) segments(x, height[i - 1], x, height[i], col = colours[i], lwd = 4)))
}