#' Adds time series of minimum SSI to existing snow profile plot
#'
#' Adds time series of minimum SSI to existing snow profile plot
#' @param Wx Weather dataframe created with getWeather() function
#' @param col Color of line
#' @param lwd Line width
#' @param lty Line type
#' @param WithValues Switch for adding points with values
#' @param cex.point Size of points
#' @examples 
#' require(SarpSnowAnalysis)
#' 
#' ## Get data
#' DBName <- "mwhs"
#' Site <- "VIR092390"
#' Profiles <- getProfiles(DBName, Sites = Site)
#' Wx <- getWeather(DBName, Sites = Site)
#' 
#' ## Plot time series
#' plotTSSnowProfile(Profiles, SiteName = Site, HighlightDateStart = "2018-11-18")
#' plotTSSnowProfileAddSkiPen(Wx, col = "gold")
#' plotTSSnowProfileAddMinSSI(Wx)
#'
#' @export

plotTSSnowProfileAddMinSSI <- function(Wx, col = "black", lwd = 3, lty = 1, WithValues = T, cex.points = 2) {
  
  Wx$date <- as.Date(substr(Wx$date, 1, 10))
  
  segments(x0 = Wx$date - 0.5, y0 = Wx$z_ssi, x1 = Wx$date + 0.5, lwd = lwd, col = col)
  
  for (i in 2:nrow(Wx)) {
    segments(x0 = Wx$date[i] - 0.5, y0 = Wx$z_ssi[i - 1], y1 = Wx$z_ssi[i], lwd = lwd, col = col)
  }
  
  if (WithValues) {
    Wx <- Wx[Wx$z_ssi != Wx$hs,]
    points(Wx$date, Wx$z_ssi, pch = 21, bg = getColoursSSI(Wx$ssi), cex = cex.points)
  }
  
  # Wx$ssicat <- cut(Wx$ssi, categories)
  # Color <- rev(RColorBrewer::brewer.pal(length(categories), col.brewer.name))
  # Wx$ssicol <- Color[as.numeric(Wx$ssicat)]
  # 
  # lines(Wx$date, Wx$z_ssi, lwd = 2)
  # points(Wx$date, Wx$z_ssi, pch = 21, bg = Wx$ssicol)
  
}