#' Adds ski penetration to existing snow profile plot
#'
#' Adds ski penetration to existing snow profile plot
#' @param Wx Weather dataframe created with getWeather() function
#' @param col Color of line
#' @param lwd Line width
#' @param lty Line type
#' @examples 
#' require(SarpSnowAnalysis)
#' 
#' ## Get data
#' DBName <- "mwhs"
#' Site <- "VIR092390"
#' Profiles <- getProfiles(DBName, Sites = Site)
#' Wx <- getWeather(DBName, Sites = Site)
#' 
#' ## Plot time series
#' plotTSSnowProfile(Profiles, SiteName = Site, HighlightDateStart = "2018-11-18")
#' plotTSSnowProfileAddSkiPen(Wx, col = "gold")
#' plotTSSnowProfileAddMinSSI(Wx)
#'
#' @export

plotTSSnowProfileAddSkiPen <- function(Wx, col = "black", lwd = 3, lty = 1) {
  
  Wx$date <- as.Date(substr(Wx$date, 1, 10))
  Wx$ski_pen_depth <- Wx$hs - Wx$ski_pen
  Wx$ski_pen_depth[Wx$ski_pen_depth <= 0] <- 0
  
  segments(x0 = Wx$date - 0.5, y0 = Wx$ski_pen_depth, x1 = Wx$date + 0.5, lwd = lwd, col = col, lty = lty)
  
  for (i in 2:nrow(Wx)) {
    segments(x0 = Wx$date[i] - 0.5, y0 = Wx$ski_pen_depth[i - 1], y1 = Wx$ski_pen_depth[i], lwd = lwd, col = col, lty = lty)
    
  }
  
}