#' Rbind all profiles into single table
#'
#' @param x either a single snowprofile or list of snowprofiles
#' @param metaCols metadata columns to copy into every row
#'
#' @return dataframe
#' @export
#'
#' @examples
#' profileTable <- rbind(profiles, metaCols = c('date', 'vstation', 'vstation_id', 'angle', 'aspect'))
rbind.snowprofile <- function(x, metaCols = NULL)
{
  # Continue if x is a snowprofile or a list of profiles
  if (is(x, "snowprofiles") | is(x, "list")) {
    
    # If metadata columns aren't specified then take all except layers
    if (is.null(metaCols)) {
      if (is(x, "list")) {
        metaCols <- names(x[[1]])
      } else {metaCols <- names(x) }
      metaCols[metaCols == 'layers'] <- NULL      
    }
    
    # Add metadata as columns in the layer tables
    for (i in 1:length(x)) {
      for (m in metaCols) {
        x[[i]]$layers[m] <- x[[i]][[m]][1]
      }
    }  
    
    # Rbind all the layers
    allProfiles <- do.call(rbind, lapply(x, function(i) i$layers))
    print(class(allProfiles))
    return(allProfiles)
    
  } else {
    return()
  }
}