#' Construct snowprofile yet
#'
#' @param x dataframe queried from mysql database
#' @param hasDem dataframe includes DEM with lat, lon, elev, band (default)
#'
#' @return snowprofile object
#' @export
#'

snowprofileMysql <- function(x, hasDem = FALSE) {
  
  ## Extract layers
  layers <- x[, names(x) %in% c('height', 
                                'deposition_date', 
                                'density', 
                                'temperature', 
                                'lwc', 
                                'grain_size', 
                                'grain_class', 
                                'hardness', 
                                'ssi')]
  ## Format layers
  layers <- formatLayers(layers)
  
  ## Create snowprofile object 
  object <- list(date = x$date[1],
                 time = x$time[1],
                 datetimeUTC = x$datetimeUTC[1],
                 vstation = x$vstation[1], 
                 vstation_id = x$vstation_id[1], 
                 angle = x$angle[1], 
                 aspect = x$aspect[1],
                 profileType = "vstation",
                 layers = layers)
  
  ## Add geospatial information if provided
  if (hasDem) {
    object$elev <- x$elev[1]
    object$band <- x$band[1]
    object$lon <- x$lon[1]
    object$lat <- x$lat[1]
    object$zone <- x$zone[1]
  }
  
  ## Add class information
  class(object) <- "snowprofile"
  
  ## Return
  return(object)
  
}
