#' Summary statistics
#'
#' @param x snowprofile object
#'
#' @export
#'
#' @examples
#' summary(snowprofile)
summary.snowprofile <- function(x)
{
  cat(paste0("Snowprofile:\t|", x$vstation, "| at |", x$date, "|"))
  cat("\n\t\t")
  cat(paste0("Slope:", x$angle, ", "))
  cat(paste0("Aspect:", x$aspect, ", "))
  cat(paste0("HS:", max(x$layers$height), "cm , "))
  cat(paste0("Layers:", nrow(x$layers), "\n"))
}
