% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getProfiles.R
\name{getProfiles}
\alias{getProfiles}
\title{Get snowprofiles from database}
\usage{
getProfiles(DBName, Sites = NA, DateStart = NA, DateEnd = DateStart,
  TimeDiffUTC = -8, dem = NULL, SizeCheck = 1e+05, Verbose = FALSE)
}
\arguments{
\item{DBName}{database name}

\item{Sites}{a single or vector of vstation_ids to query}

\item{DateStart}{Start date of profile query. Default NA gives you all dates.}

\item{DateEnd}{End date of profile query. By default equal to DateStart.}

\item{TimeDiffUTC}{Difference to UTM in hours. Default is -8 hours for PST.}

\item{dem}{add spatial information}

\item{SizeCheck}{Switch for including check whether more than 100,000 are being requested. Default is TRUE.}

\item{Verbose}{Switch for printing SQL query. Default is FALSE.}
}
\value{
list of snowprofile objects
}
\description{
Get snowprofiles from database
}
\examples{
require(SarpSnowGeneral)
require(SarpSnowAnalysis)

DBName <- "test2018"
Site <- "HRDPS_518_700"
Date <- "2018-01-07"

slopes <- listSlopes(DBName, dem)

## Profile timeline
pro.timeline <- getProfiles(DBName, Sites = Site)
pro.timeline <- getProfiles(DBName, Sites = Site, DateStart = "2018-01-01", DateEnd = "2018-02-01")

## Profile map with all slopes
pro.map <- getProfiles(DBName, DateStart = Date)

## Profile map with only flat slopes
pro.flat <- getProfiles(DBName, DateStart = Date, Sites = subset(slopes, angle == 0)$vstation_id)
}
