% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getWeather.R
\name{getWeather}
\alias{getWeather}
\title{Get weather timeseries from database}
\usage{
getWeather(DBName, Sites = NA, DateStart = NA, DateEnd = DateStart,
  DailyTime = "08:00:00", TimeDiffUTC = -8, dem = NULL,
  SizeCheck = 1e+05, Verbose = FALSE)
}
\arguments{
\item{DBName}{Database name}

\item{Sites}{A single or vector of vstation_ids to query}

\item{DateStart}{Start date of date interval. Default is NA}

\item{DateEnd}{End date of date interval. Default is DateStart. This means that if DateStart is specified only, only a single date will be downloaded.}

\item{dem}{add spatial information}

\item{SizeCheck}{Switch for including check for large downloads. Default is 100,000. Set to NA to avoid check.}

\item{Verbose}{Switch for printing SQL query. Default is FALSE.}

\item{DailyTime.}{Time for daily record. Default is '05:00:00'. This means that only the 5am record is downloaded for each day. To download the hourly records, set DailyTime = NA.}

\item{TimeDiffUTM.}{Difference to UTM in hours. Default is -8 hours for PST.}
}
\value{
dataframe of weather
}
\description{
Get weather timeseries from database
}
\examples{
require(SarpSnowGeneral)
require(SarpSnowAnalysis)

DBName <- "test2018"
Site <- "HRDPS_518_700"
Date <- "2018-01-07"

slopes <- listSlopes(DBName, dem)

## Get all weather
wx <- getWeather(DBName)

## Weather timeline
wx.timeline <- getWeather(DBName, Sites = Site)
wx.timeline <- getWeather(DBName, Sites = Site, DateStart = "2018-01-01", DateEnd = "2018-02-01")

## Profile map with all slopes
wx.map <- getWeather(DBName, DateStart = Date)

## Profile map with only flat slopes
wx.flat <- getWeather(DBName, DateStart = Date, Sites = subset(slopes, angle == 0)$vstation_id)
}
