% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getWeatherDailySummary.R
\name{getWeatherDailySummary}
\alias{getWeatherDailySummary}
\title{Get weather daily summary timeseries from database}
\usage{
getWeatherDailySummary(DBName, Sites, DateStart = NA,
  DateEnd = DateStart, DailyTime = "08:00:00", TimeDiffUTC = -8,
  dem = NULL, Verbose = FALSE)
}
\arguments{
\item{DBName}{Database name}

\item{Sites}{A single or vector of vstation_ids to query}

\item{DateStart}{Start date of date interval. Default is NA}

\item{DateEnd}{End date of date interval. Default is DateStart. This means that if DateStart is specified only, only a single date will be downloaded.}

\item{dem}{add spatial information}

\item{Verbose}{Switch for printing SQL query. Default is FALSE.}

\item{DailyTime.}{Time for daily record. Default is '08:00:00'. This means that daily summary is from 7am the previous day to 8am current day.}

\item{TimeDiffUTM.}{Difference to UTM in hours. Default is -8 hours for PST.}

\item{SizeCheck}{Switch for including check for large downloads. Default is 100,000. Set to NA to avoid check.}
}
\value{
dataframe of weather
}
\description{
Get weather daily summary timeseries from database
}
\examples{
require(SarpSnowGeneral)
require(SarpSnowAnalysis)

DB <- "GNP"
Site <- "VIR152521"

DateStart <- "2016-01-01"
DateEnd <- "2016-05-01"

## Retrieve data 
WxDS <- getWeatherDailySummary("GNP", Sites = Site, DateStart = DateStart, DateEnd = DateEnd)

## Base plot
ylim <- c(min(WxDS$ta_min), max(WxDS$ta_max))
plot(WxDS$date, WxDS$ta_avg, type = "n", ylim=ylim, ylab = "Temp", xlab = "Dates", main = "Daily Temperature Summary")
grid()
abline(h = 0, lwd = 2, lty = 2, col="grey")

## Plotting
lines(WxDS$date, WxDS$ta_avg, col="black", lwd = 2)
lines(WxDS$date, WxDS$ta_min, col="blue")
lines(WxDS$date, WxDS$ta_max, col="red")
}
