% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotParameter.R
\name{plotParameter}
\alias{plotParameter}
\title{Plot a vertical parameter}
\usage{
plotParameter(profile, x)
}
\arguments{
\item{profile}{snowprofile object}

\item{x}{vector of x axis values to draw veritcal segments}
}
\description{
plot a vertical line
TODO: implement plotrix::rescale to colour code other parameters
}
\examples{
# Load data
profileLocation <- "HRDPS_518_700"
spros <- getProfiles(DBName, slopes = profileLocation, dem = dem)

# Define x-axis values
theDates <- as.Date(sapply(spros, function(x) x$date))

# Initialize empty plot
plot(NA, NA, ylim = c(0,250), xlim = c(min(theDates),max(theDates)), ylab = '', xlab = '')

# Draw segments
invisible(sapply(1:length(spros), function(i) plotParameter(spros[[i]], theDates[i])))
 
}
