% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTSSnowProfile.R
\name{plotTSSnowProfile}
\alias{plotTSSnowProfile}
\title{Plot time series of snow profiles}
\usage{
plotTSSnowProfile(Profiles, Type = "graintype", WithXAxis = T,
  DateStart = NA, DateEnd = NA, TrackingDates = NA,
  TrackingCol = "black", TrackingLwd = 2, HatchHST = FALSE,
  HighlightDateStart = NA, HighlightDateEnd = HighlightDateStart,
  HighlightCol = "light grey", cex.axis = 1, cex.lab = 1,
  SiteName = NULL, main = NA)
}
\arguments{
\item{Profiles}{List of snow profiles created with getProfiles() function}

\item{Type}{TYpe of profile to be plotted. So far the following types are available: graintype (default), hardness, temperature, density, grainsize.}

\item{WithXAxis}{Switch for plotting x-axis (default = TRUE).}

\item{DateStart}{Start date for plot. If not provided, the function takes the date range from Profiles (default = NA).}

\item{DateEnd}{End date for plot. If not provided, the function takes the date range from Profiles (default = NA).}

\item{TrackingDates}{Date or array of dates for tracing layers (default = NA).}

\item{TrackingCol}{Color of tracking lines (default = "black")}

\item{TrackingLwd}{Width of tracking lines (default = 2)}

\item{HatchHST}{Switch for whether HST should be hatched (default is FALSE).}

\item{HighlightDateStart}{Start of highlighted time period (default = NA).}

\item{HighlightDateEnd}{End of highlighted time period (default = HighlightDateStart).}

\item{HighlightCol}{Color for highlighted time period (default = "light grey").}

\item{cex.axis}{cex.axis (default = 1.0).}

\item{cex.lab}{cex.lab (default = 1.0).}

\item{SiteName}{SiteName (default = NULL).}
}
\description{
Plot time series of snow profiles
}
\examples{
require(SarpSnowAnalysis)

## Get data
DBName <- "test2018"
Site <- "HRDPS_518_700"
Profiles <- getProfiles(DBName, Sites = Site)

## Plot snowprofile
plotTSSnowProfile(Profiles, DateStart = "2017-12-01", DateEnd = "2018-04-01", 
                  HighlightDateStart = "2017-12-30", HighlightDateEnd = "2018-01-05",
                  TrackingDates = "2017-12-30", SiteName = Site, main = "Seasonal Snowprofile with 2018-01-05 layer tracked")

plotTSSnowProfile(Profiles, Type = "density", DateStart = "2017-12-01", DateEnd = "2018-04-01", 
                  HighlightDateStart = "2017-12-30", HighlightDateEnd = "2018-01-05",
                  TrackingDates = "2017-12-30", SiteName = Site, main = "Seasonal Snowprofile with 2018-01-05 layer tracked: DENSITY")

plotTSSnowProfile(Profiles, Type = "temp", DateStart = "2017-12-01", DateEnd = "2018-04-01", 
                  HighlightDateStart = "2017-12-30", HighlightDateEnd = "2018-01-05",
                  TrackingDates = "2017-12-30", SiteName = Site, main = "Seasonal Snowprofile with 2018-01-05 layer tracked: SNOW TEMPERATURE")

plotTSSnowProfile(Profiles, Type = "grainsize", DateStart = "2017-12-01", DateEnd = "2018-04-01", 
                  HighlightDateStart = "2017-12-30", HighlightDateEnd = "2018-01-05",
                  TrackingDates = "2017-12-30", SiteName = Site, main = "Seasonal Snowprofile with 2018-01-05 layer tracked: GRAIN SIZE")

plotTSSnowProfile(Profiles, Type = "hardness", DateStart = "2017-12-01", DateEnd = "2018-04-01", 
                  HighlightDateStart = "2017-12-30", HighlightDateEnd = "2018-01-05",
                  TrackingDates = "2017-12-30", SiteName = Site, main = "Seasonal Snowprofile with 2018-01-05 layer tracked: HARDNESS")
                  
plotTSSnowProfile(Profiles, Type = "ssi", DateStart = "2017-12-01", DateEnd = "2018-04-01", 
                  HighlightDateStart = "2017-12-30", HighlightDateEnd = "2018-01-05",
                  TrackingDates = "2017-12-30", SiteName = Site, main = "Seasonal Snowprofile with 2018-01-05 layer tracked: SSI")

}
