% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTSSnowProfileAddMinSSI.R
\name{plotTSSnowProfileAddMinSSI}
\alias{plotTSSnowProfileAddMinSSI}
\title{Adds time series of minimum SSI to existing snow profile plot}
\usage{
plotTSSnowProfileAddMinSSI(Wx, col = "black", lwd = 3, lty = 1,
  WithValues = T, cex.points = 2)
}
\arguments{
\item{Wx}{Weather dataframe created with getWeather() function}

\item{col}{Color of line}

\item{lwd}{Line width}

\item{lty}{Line type}

\item{WithValues}{Switch for adding points with values}

\item{cex.point}{Size of points}
}
\description{
Adds time series of minimum SSI to existing snow profile plot
}
\examples{
require(SarpSnowAnalysis)

## Get data
DBName <- "mwhs"
Site <- "VIR092390"
Profiles <- getProfiles(DBName, Sites = Site)
Wx <- getWeather(DBName, Sites = Site)

## Plot time series
plotTSSnowProfile(Profiles, SiteName = Site, HighlightDateStart = "2018-11-18")
plotTSSnowProfileAddSkiPen(Wx, col = "gold")
plotTSSnowProfileAddMinSSI(Wx)

}
