% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTSSnowProfileAddSkiPen.R
\name{plotTSSnowProfileAddSkiPen}
\alias{plotTSSnowProfileAddSkiPen}
\title{Adds ski penetration to existing snow profile plot}
\usage{
plotTSSnowProfileAddSkiPen(Wx, col = "black", lwd = 3, lty = 1)
}
\arguments{
\item{Wx}{Weather dataframe created with getWeather() function}

\item{col}{Color of line}

\item{lwd}{Line width}

\item{lty}{Line type}
}
\description{
Adds ski penetration to existing snow profile plot
}
\examples{
require(SarpSnowAnalysis)

## Get data
DBName <- "mwhs"
Site <- "VIR092390"
Profiles <- getProfiles(DBName, Sites = Site)
Wx <- getWeather(DBName, Sites = Site)

## Plot time series
plotTSSnowProfile(Profiles, SiteName = Site, HighlightDateStart = "2018-11-18")
plotTSSnowProfileAddSkiPen(Wx, col = "gold")
plotTSSnowProfileAddMinSSI(Wx)

}
