% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTSSnowpackWx.R
\name{plotTSSnowpackWx}
\alias{plotTSSnowpackWx}
\title{Plot time series of weather and snowpack parameters from snowpack simulations}
\usage{
plotTSSnowpackWx(Wx, ParamName, WithXAxis = T, DateStart = NA,
  DateEnd = NA, FaintLines = TRUE, FaintCol = "#A9A9A9",
  FaintLwd = 0.25, SummaryQuantiles = c(0.5, 0.25, 0.75),
  Threshold = NA, ThresholdCol = "#B22222", HighlightDateStart = NA,
  HighlightDateEnd = HighlightDateStart, HighlightCol = "light grey",
  cex.axis = 1, cex.lab = 1, SiteName = NULL, ylim = NA,
  main = NA)
}
\arguments{
\item{Wx}{Weather dataframe created with getWeather() function}

\item{ParamName}{Name of parameter to be plotted}

\item{WithXAxis}{Switch for plotting x-axis (default = TRUE).}

\item{DateStart}{Start date for plot. If not provided, the function takes the date range from Wx (default = NA).}

\item{DateEnd}{End date for plot. If not provided, the function takes the date range from Wx (default = NA).}

\item{HighlightDateStart}{Start of highlighted time period (default = NA).}

\item{HighlightDateEnd}{End of highlighted time period (default = HighlightDateStart).}

\item{HighlightCol}{Color for highlighted time period (default = "light grey").}

\item{cex.axis}{cex.axis (default = 1.0).}

\item{cex.lab}{cex.lab (default = 1.0).}

\item{SiteName}{SiteName (default = NULL).}
}
\description{
Plot time series of weather and snowpack parameters from snowpack simulations
}
\examples{
require(SarpSnowAnalysis)

## Get data
DBName <- "test2018"
Site <- "HRDPS_518_700"
Wx <- getWeather(DBName, Sites = Site)

## Plot snowprofile
plotTSSnowpackWx(Wx, DateStart = "2017-12-01", DateEnd = "2018-04-01", 
                 HighlightDateStart = "2017-12-30", HighlightDateEnd = "2018-01-05",
                 TrackingDates = "2017-12-30", SiteName = Site, main = "Seasonal Snowprofile with 2018-01-05 layer tracked")

}
