#' Connect to snowpack analysis database
#'
#' Connect to snowpack analysis database on SARP MySQL Server.
#' Before you can connect to the database for the first time, you have to store the database credentials in an .REnviron file in your home directory. 
#' The necessary parameters to include are: Snow_DB_Host (host URL), Snow_DB_Un (username), Snow_DB_Pw (password), and Snow_DB_NamePrefix (e.g., 'snowpack_' in 'snowpack_test'). 
#' Use the function Sys.getenv("HOME") to see where the appropriate home directory is on your system.
#' See https://db.rstudio.com/best-practices/managing-credentials/ and https://csgillespie.github.io/efficientR/r-startup.html#the-location-of-startup-files for additional information.
#' 
#' @param DBName Name extension of database name (e.g., test for snowpack_test). The prefix is defined in the .Renviron file.
#'
#' @return Database connection of the class MySQLConnection

connectToSnowpackDB <- function(DBName) {
  
  DBName <- paste0(Sys.getenv("Snow_DB_NamePrefix"), tolower(DBName))
  
  DBCon <- RMySQL::dbConnect(dbDriver("MySQL"),
                             host = Sys.getenv("Snow_DB_Host"),
                             user = Sys.getenv("Snow_DB_Un"),
                             password = Sys.getenv("Snow_DB_Pw"),
                             dbname = DBName)
  
  return(DBCon)
  
}
