#' Find the nearest in elevation within buffer
#'
#' @param geometry 
#' @param dem 
#' @param knn 
#' @param max.neighbour 
#'
#' @export
#'
#'
findNearestPointElevations <- function(geometry, dem, knn = 10, max.neighbour = FALSE, name.col = NULL)
{
  # Initialize list of indices
  gridIndex <- rep(NA, nrow(geometry))
  
  # Progress bar
  pb <- txtProgressBar(min = 1, max = nrow(geometry@coords), style = 3)
  
  # Loop through locations and find the index of the grid points with closest/max elevation whithin neighbourhood
  for (i in 1:nrow(geometry@coords)) {
    setTxtProgressBar(pb, i)
    
    # Find the index of the k nearest neighbours
    distances <- geosphere::distCosine(dem, geometry@coords[i,])
    kneighbour.index <- which(distances <= sort(distances)[knn], arr.ind = T)
    
    # Closest elevation to real site
    if (!max.neighbour) {
      elev.diff <- abs(dem$elev[kneighbour.index] - geometry$elev[i])
      nearest.elev <- kneighbour.index[which.min(elev.diff)]
      point.choice <- nearest.elev
      
      # Max elevation out of the neighbours
    } else {
      max.elev <- kneighbour.index[which.max(dem$elev[kneighbour.index])]
      point.choice <- max.elev
    }
    gridIndex[i] <- point.choice
  }
  close(pb)
  
  # Return DEM at select locations
  return(dem[gridIndex,])
}