#' Find the nearest point
#'
#' @param geometry 
#' @param dem 
#' @param name.col 
#'
#' @export

findNearestPoints <- function(geometry, dem, name.col = NULL) {

  # Find index of grid points with minimum distances
  gridIndex <- apply(geometry@coords, 1, function(i) which.min(geosphere::distCosine(dem, i)))
  
  # Return DEM at select locations
  return(dem[gridIndex,])
  
}