#' Find points in polygons
#'
#' @param geometry a SpatialPolygons dataframe
#' @param dem a grid of NWP coordinates
#' @param name.col column name from the geometry that contains the names of subregions (zones)
#'
#' @return a SpatialPoints dataframe
#' @export
#' 

findPointsInPolygons <- function(geometry, dem, name.col = 'name')
{
  # Add polygon names or NA to each point in the dem
  dem$zone <- sp::over(dem, geometry) [,name.col]
  
  # Subset only the dem points in polygons and return
  gridPoints <- subset(dem, !is.na(zone))
  
  # Format zone names
  gridPoints$zone <- toupper(gridPoints$zone)
  gridPoints$zone <- gsub("__", "_", gsub(" ", "_", gsub("\\/", "", gsub("\\.", "", gsub("-", "", gridPoints$zone)))))
  
  return(gridPoints)
}
