#' Gets record from snowpack analysis database based on SQL query
#'
#' Gets record from snowpack analysis database based on SQL query
#' @param DBName Name extension of database name
#' @param Query Properly formatted SQL query
#' @param Verbose Switch for printing SQL query. Default value is FALSE.
#' @param SuppressDBWarnings Switch for turning warnings off. Default value is TRUE.
#' @param MaxNumTries Number of times the function tries to connect to the database
#' @return Dataframe with result
#' 
#' @examples
#' require(SarpSnowGeneral)
#' 
#' DBName <- "test2018"
#' Query <- "Select * from executions"
#' 
#' Tbl_Exec <- getRecordsFromQuery(DBName = DBName, Query = Query)
#' 
#' @export

getRecordsFromQuery <- function(DBName, Query, Verbose = F, SuppressDBWarnings = T, MaxNumTries = 10) {
  
  ## Preparation
  if(Verbose) {cat(Query, ";\n\n")}
  if (SuppressDBWarnings) {options(warn = -1)}
  
  ## Connect to DB
  DBCon <- tryMultipleTimes(connectToSnowpackDB(DBName = DBName), MaxNumTries = MaxNumTries)
  
  ## Retrieve data  
  Result <- RMySQL::dbSendQuery(DBCon, Query)
  ResultDF <- RMySQL::dbFetch(Result, n = -1)
  dbDisconnect(DBCon)
  rm(Result)
  
  ## Finish
  if (SuppressDBWarnings) {options(warn = 0)}
  rm(DBCon)
  
  return(ResultDF)
  
}
