#' Send SQL query to database.
#'
#' Send SQL query that does not produce any result (e.g., delete query, insert query, ...) to database. IMPORTANT: Only use for single queries or short loops. Long loops are much faster if the Db connection is established once and all records are submitted together.
#' @param DBName Name extension of database name
#' @param Query SQL query.
#' @param Verbose Switch for printing SQL query. Default value is FALSE.
#' @param SuppressPostgreSQLWarnings Switch for turning warnings off. Default value is TRUE.
#' @param MaxNumTries Number of maximum tries that are attempted. Default value is 10.
#' @export

sendQueryToDB <- function(DBName, Query, Verbose=F, MaxNumTries=10) {
  
  if(Verbose) {cat(Query, "\n")}
  
  DBCon <- tryMultipleTimes(connectToSnowpackDB(DBName), MaxNumTries=MaxNumTries)
  Result <- dbSendQuery(DBCon, Query)
  
  dbDisconnect(DBCon)
  rm(DBCon)

}
