#' Set elevation bands
#'
#' @param dem a dem with and elev column
#' @param treeline.widths how far above and below the treeline elevation is included (default currently c(200,0) to account for low elevation bias in NWP model)
#' @param treeline preset treeline value(s)
#'
#' @return DEM with a new column 'band' with values of BTL/TL/ALP
#' 
#' @export
#'
setElevationBands <- function(dem, treeline.widths = c(200, 0), treeline = NULL)
{
  if (!is.null(treeline)) {dem$treeline <- treeline}
  dem$band <- factor('TL', levels = c('BTL', 'TL', 'ALP'), ordered = T)
  dem$band[dem$elev < (dem$treeline - treeline.widths[1])] <- 'BTL'
  dem$band[dem$elev > (dem$treeline + treeline.widths[2])] <- 'ALP'
  return(dem)
}
