#' Determine study area for a bulletin region
#' 
#' @param name name of the study area
#' @param regionName name of the bulletin region in the database
#' @param hrdps DEM of HRDPS model
#' @param hrdpswest DEM of HRDPS_WEST model
#' @param elevationBands DEM contains preset treeline elevations for each gridpoint
#' @param regionSeason season of the region in the database (default 2018)
#'
#' @return studyArea object
#' @export
#'
#' @examples
#' library(SarpBulletinTools)
#' library(SarpBulletinToolsPrivate)
#' hrdps <- readRDS(url("http://data.avalancheresearch.ca/Snowmodels/dem/HRDPS_DEM.rds"))
#' hrdpswest <- readRDS(url("http://data.avalancheresearch.ca/Snowmodels/dem/HRDPS_WEST_DEM.rds"))
#' gnp <- studyAreaBulletin("GNP", "Glacier", hrdps, hrdpswest)
#' 

studyAreaBulletin <- function(name, regionName, hrdps = NULL, hrdpswest = NULL, elevationBands = TRUE, regionSeason = 2018)
{

    # Extract geometry of bulletin
  geometry <- SarpBulletinTools::getBulletinRegionGeomSPDF(regionName, Season = regionSeason)
  
  # Create study area
  studyArea <- studyArea.default(name, geometry, hrdps, hrdpswest, elevationBands)
  
  return(studyArea)
}