# 
#' Determine study area from kml polygons
#'
#' @param name name of the study area
#' @param kmlFile path to kml file containing polygons
#' @param kmlRegionName the name of the feature in the kml file
#' @param hrdps DEM of HRDPS model
#' @param hrdpswest DEM of HRDPS_WEST model
#' @param elevationBands DEM contains preset treeline elevations for each gridpoint
#'
#' @return studyArea object
#' @export
#'
#' @examples
#' hrdps <- readRDS(url("http://data.avalancheresearch.ca/Snowmodels/dem/HRDPS_DEM.rds"))
#' hrdpswest <- readRDS(url("http://data.avalancheresearch.ca/Snowmodels/dem/HRDPS_WEST_DEM.rds"))
#' heli <- studyAreaKml("heli", kmlFile = 'kml/Helicat.kml', kmlRegionName = 'Helicat', hrdps, hrdpswest)

studyAreaKml <- function(name, kmlFile, kmlRegionName, hrdps = NULL, hrdpswest = NULL, elevationBands = TRUE)
{
  
  #Provide a kml file with polygon
  geometry <- rgdal::readOGR(kmlFile, kmlRegionName)
  
  # Create study area
  studyArea <- studyArea.default(name, geometry, hrdps, hrdpswest, elevationBands, name.col = 'Name')
  
  return(studyArea)
}