#' Determine study area a list of latlon points
#' 
#' @param name name of the study area
#' @param spatialPoints SpatialPointsDataFrame
#' @param hrdps DEM of HRDPS model
#' @param hrdpswest DEM of HRDPS_WEST model
#' @param elevationBands DEM contains preset treeline elevations for each gridpoint
#'
#' @return studyArea object
#' @export
#'
#' @examples
#' hrdps <- readRDS(url("http://data.avalancheresearch.ca/Snowmodels/dem/HRDPS_DEM.rds"))
#' hrdpswest <- readRDS(url("http://data.avalancheresearch.ca/Snowmodels/dem/HRDPS_WEST_DEM.rds"))
#'

studyAreaPoints <- function(name, spatialPoints, hrdps = NULL, hrdpswest = NULL, elevationBands = TRUE)
{
  
  # Create study area
  studyArea <- studyArea.default(name, spatialPoints, hrdps, hrdpswest, elevationBands)
  
  return(studyArea)
}