% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getColoursDensity.R
\name{getColoursDensity}
\alias{getColoursDensity}
\title{Gets colors for plotting snow density values}
\usage{
getColoursDensity(Values, Resolution = 101, Verbose = F)
}
\arguments{
\item{Values}{Liquid water content values}

\item{Resolution}{Resolution of color scale. Default is 100.}

\item{Verbose}{Switch for writing out value and html color tuplets for debugging.}
}
\value{
Array with HTML color codes
}
\description{
Gets colors for plotting snow density values in snowprofiles. Colors are consistent with niViz at https://niviz.org
}
\examples{
require(SarpSnowGeneral)

Density <- seq(0,700, by=10)

plot(x = rep(1,length(Density)), y = Density, col = getColoursDensity(Density), pch = 19, cex = 3)

}
