% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getColoursHardness.R
\name{getColoursHardness}
\alias{getColoursHardness}
\title{Gets colors for plotting snow hardness values}
\usage{
getColoursHardness(Values, Resolution = 101, Verbose = F)
}
\arguments{
\item{Values}{Hardness values}

\item{Resolution}{Resolution of color scale. Default is 100.}

\item{Verbose}{Switch for writing out value and html color tuplets for debugging.}
}
\value{
Array with HTML color codes
}
\description{
Gets colors for plotting snow hardness values in snowprofiles.
}
\examples{
require(SarpSnowGeneral)

Hardness <- c(1:5)
plot(x = rep(1,length(Hardness)), y = Hardness, col = getColoursHardness(Hardness), pch = 19,cex = 3)

}
