% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getColoursLWC.R
\name{getColoursLWC}
\alias{getColoursLWC}
\title{Gets colors for plotting LWC values}
\usage{
getColoursLWC(Values, Resolution = 101, Verbose = F)
}
\arguments{
\item{Values}{Liquid water content values}

\item{Resolution}{Resolution of color scale. Default is 100.}

\item{Verbose}{Switch for writing out value and html color tuplets for debugging.}
}
\value{
Array with HTML color codes
}
\description{
Gets colors for plotting LWC values in snowprofiles. Colors are consistent with niViz at https://niviz.org
}
\examples{
require(SarpSnowGeneral)

LWC <- seq(0,6, by=0.1)

plot(x = rep(1,length(LWC)), y = LWC, col = getColoursLWC(LWC), pch = 19, cex = 3)

}
