% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getColoursSSI.R
\name{getColoursSSI}
\alias{getColoursSSI}
\title{Gets colors for plotting SSI values}
\usage{
getColoursSSI(Values, Resolution = 101, Verbose = F)
}
\arguments{
\item{Values}{SSI values}

\item{Resolution}{Resolution of color scale. Default is 100.}

\item{Verbose}{Switch for writing out value and html color tuplets for debugging.}
}
\value{
Array with HTML color codes
}
\description{
Gets colors for plotting SSI values in snowprofiles.
}
\examples{
require(SarpSnowGeneral)

SSI <- c(-999, 1:6)
plot(rep(1,length(SSI)), bg = getColoursSSI(SSI), pch = 21,cex = 3)
text(x = c(1:length(SSI)), y = 1, labels = SSI, pos = 3, offset = 2)

}
